/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.layers;

import java.util.Set;

/**
 * @author Antti Villberg
 */
public interface ILayersEditor extends ILayers {

    public interface ILayersEditorListener {

        void layerAdded(ILayer layer);
        void layerRemoved(ILayer layer);

        void layerActivated(ILayer layer);
        void layerDeactivated(ILayer layer);

        void ignoreFocusChanged(boolean value);
        void ignoreVisibilityChanged(boolean value);

        /**
         * @since 1.48.0
         */
        default void focusImagesChanged(boolean value) {}

    }

    void setFocusImages(boolean value);
    void setIgnoreFocusSettings(boolean value);
    void setIgnoreVisibilitySettings(boolean value);

    void addLayerEditorListener(ILayersEditorListener listener);
    void removeLayerEditorListener(ILayersEditorListener listener);

    void addLayer(ILayer layer);
    void removeLayer(ILayer layer);

    void activate(ILayer layer);
    void deactivate(ILayer layer);

    void update(Set<ILayer> allLayers, Set<ILayer> visibleLayers);
}
