/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.image.impl;

import org.simantics.g2d.image.Image;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.cache.ProvisionException;

public class RasterizingProvider extends AbstractProviderProxy implements IFactory<Image> {

	public RasterizingProvider(IProvider<Image> source) {
		super(source);
	}
	
	@Override
	public Image get() throws ProvisionException {
		Image i = source.get();
// We dont want MipMap in parametrized painting
//		if (i.getFeatures().contains(Feature.Vector))
//			return new MipMapBufferedImage(i);
		return i;
	}
}


