/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.image.impl;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.EnumSet;

import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.ImageUtils;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ImageNode;

/**
 * Adapts {@link BufferedImage} to {@link Image}
 * 
 * @See {@link ImageUtils}
 * @author Toni Kalajainen
 */
public class AWTImage extends AbstractImage implements Image {

    static EnumSet<Feature> feats = EnumSet.noneOf(Feature.class);

    BufferedImage bi;
    Rectangle2D rect;
    float alpha;

    public AWTImage(BufferedImage bi, float alpha) {
        assert(bi!=null);
        this.bi = bi;
        this.alpha = alpha;
        rect = new Rectangle2D.Double(bi.getMinX(),bi.getMinY(),bi.getWidth(), bi.getHeight());
    }

    public AWTImage(BufferedImage bi) {
        this(bi, 1.0f);
    }

    @Override
    public Rectangle2D getBounds() {
        return rect;
    }

    @Override
    public Shape getOutline() {
        return rect;
    }

    @Override
    public Node init(G2DParentNode parent) {
        ImageNode node = parent.getOrCreateNode("image", ImageNode.class);
        node.setImage(bi);
        node.setAlpha(alpha);
        node.setZIndex(-100);
        return node;
    }

    @Override
    public EnumSet<Feature> getFeatures() {
        return feats;
    }

}
