/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.gallery;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.g2d.diagram.handler.layout.FlowLayout;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.utils.datastructures.cache.IProvider;

public class GalleryExample {

    @SuppressWarnings("unchecked")
    static IProvider<Image>[] content = new IProvider[] {
        DefaultImages.GRAB,
        DefaultImages.GRAB32,
        DefaultImages.HAND,
        DefaultImages.HAND32,
        DefaultImages.ERROR_DECORATOR,
        DefaultImages.HOURGLASS,
        DefaultImages.WHEEL
    };

    static class LabelProvider extends BaseLabelProvider implements ILabelProvider {
        @Override
        public Image getImage(Object element) {
            @SuppressWarnings("unchecked")
            IProvider<Image> img = (IProvider<Image>) element;
            return img.get();
        }
        @Override
        public String getText(Object element) {
            return element.toString();
        }
        
        @Override
        public java.awt.Image getToolTipImage(Object object) {
        	return null;
        }
        
        @Override
        public String getToolTipText(Object element) {
        	 return element.toString();
        }
        
        @Override
        public Color getToolTipForegroundColor(Object object) {
        	return null;
        }
        
        @Override
        public Color getToolTipBackgroundColor(Object object) {
        	return null;
        }
    }

    public static void main (String [] args) {
        Display display = new Display ();
        Shell shell = new Shell (display);
        shell.setLayout(new FillLayout());
        shell.setText("Gallery Example");


        GalleryViewer viewer = new GalleryViewer(shell);
        viewer.getControl();
        viewer.setContentProvider(new ArrayContentProvider());
        viewer.setLabelProvider(new LabelProvider());
        viewer.setAlign(FlowLayout.Align.Left);
        viewer.setInput(content);
        viewer.refresh();

        shell.setSize (300, 300);
        shell.open ();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch ()) display.sleep ();
        }
        display.dispose ();
    }


}
