/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.g2d.event.adapter;

import java.awt.event.KeyEvent;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyListener;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventDebugPolicy;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.KeyEvent.KeyPressedEvent;
import org.simantics.scenegraph.g2d.events.KeyEvent.KeyReleasedEvent;
import org.simantics.scenegraph.g2d.events.adapter.AbstractEventAdapter;

/**
 * Adapts SWT key events to G2D Event
 *
 * @see Event
 * @author Toni Kalajainen
 */
public class SWTKeyEventAdapter extends AbstractEventAdapter implements KeyListener {

    private final boolean DEBUG = EventDebugPolicy.SWT_KEY_EVENT_ADAPTION;

    public SWTKeyEventAdapter(Object sender, IEventHandler delegator) {
        super(sender, delegator);
    }

    public SWTKeyEventAdapter(Object sender, IEventQueue queue) {
        super(sender, queue);
    }

    @Override
    public void keyPressed(org.eclipse.swt.events.KeyEvent e) {
        if (DEBUG)
            System.out.println("SWT key pressed: " + e);
        handleEvent(
                new KeyPressedEvent(sender, e.time, e.character, adaptSWTKeyCodeToAWTKeyCode(e.keyCode), adaptSWTModifierToAWTModifier(e.stateMask)));
    }

    @Override
    public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
        if (DEBUG)
            System.out.println("SWT key released: " + e);
        handleEvent(
                new KeyReleasedEvent(sender, e.time, e.character, adaptSWTKeyCodeToAWTKeyCode(e.keyCode), adaptSWTModifierToAWTModifier(e.stateMask)));
    }

    public static int adaptSWTKeyCodeToAWTKeyCode(int swtKeyCode)
    {
        int c = swtKeyCode;


        if (swtKeyCode>=KeyEvent.VK_A+0x20 && swtKeyCode<=KeyEvent.VK_Z+0x20)
            return swtKeyCode - 0x20;

        switch(swtKeyCode) {
            case SWT.ARROW_UP: return KeyEvent.VK_UP;
            case SWT.ARROW_DOWN: return KeyEvent.VK_DOWN;
            case SWT.ARROW_LEFT: return KeyEvent.VK_LEFT;
            case SWT.ARROW_RIGHT: return KeyEvent.VK_RIGHT;
            case SWT.PAGE_UP: return KeyEvent.VK_PAGE_UP;
            case SWT.PAGE_DOWN: return KeyEvent.VK_PAGE_DOWN;
            case SWT.HOME: return KeyEvent.VK_HOME;
            case SWT.END: return KeyEvent.VK_END;
            case SWT.INSERT: return KeyEvent.VK_INSERT;
            case SWT.F1: return KeyEvent.VK_F1;
            case SWT.F2: return KeyEvent.VK_F2;
            case SWT.F3: return KeyEvent.VK_F3;
            case SWT.F4: return KeyEvent.VK_F4;
            case SWT.F5: return KeyEvent.VK_F5;
            case SWT.F6: return KeyEvent.VK_F6;
            case SWT.F7: return KeyEvent.VK_F7;
            case SWT.F8: return KeyEvent.VK_F8;
            case SWT.F9: return KeyEvent.VK_F9;
            case SWT.F10: return KeyEvent.VK_F10;
            case SWT.F11: return KeyEvent.VK_F11;
            case SWT.F12: return KeyEvent.VK_F12;
            case SWT.F13: return KeyEvent.VK_F13;
            case SWT.F14: return KeyEvent.VK_F14;
            case SWT.F15: return KeyEvent.VK_F15;
            case SWT.KEYPAD_MULTIPLY: return KeyEvent.VK_MULTIPLY;
            case SWT.KEYPAD_ADD: return KeyEvent.VK_ADD;
            case SWT.KEYPAD_SUBTRACT: return KeyEvent.VK_SUBTRACT;
            case SWT.KEYPAD_DECIMAL: return KeyEvent.VK_DECIMAL;
            case SWT.KEYPAD_DIVIDE: return KeyEvent.VK_DIVIDE;
            case SWT.KEYPAD_0: return KeyEvent.VK_NUMPAD0;
            case SWT.KEYPAD_1: return KeyEvent.VK_NUMPAD1;
            case SWT.KEYPAD_2: return KeyEvent.VK_NUMPAD2;
            case SWT.KEYPAD_3: return KeyEvent.VK_NUMPAD3;
            case SWT.KEYPAD_4: return KeyEvent.VK_NUMPAD4;
            case SWT.KEYPAD_5: return KeyEvent.VK_NUMPAD5;
            case SWT.KEYPAD_6: return KeyEvent.VK_NUMPAD6;
            case SWT.KEYPAD_7: return KeyEvent.VK_NUMPAD7;
            case SWT.KEYPAD_8: return KeyEvent.VK_NUMPAD8;
            case SWT.KEYPAD_9: return KeyEvent.VK_NUMPAD9;
            case SWT.KEYPAD_EQUAL: return KeyEvent.VK_EQUALS;
            case SWT.KEYPAD_CR: return KeyEvent.VK_ENTER; // wrong?
            case SWT.HELP: return KeyEvent.VK_HELP;
            case SWT.CAPS_LOCK: return KeyEvent.VK_CAPS_LOCK;
            case SWT.NUM_LOCK: return KeyEvent.VK_NUM_LOCK;
            case SWT.SCROLL_LOCK: return KeyEvent.VK_NUM_LOCK;
            case SWT.PAUSE: return KeyEvent.VK_PAUSE;
            //case SWT.BREAK: return KeyEvent.vk_
            case SWT.PRINT_SCREEN: return KeyEvent.VK_PRINTSCREEN;
            case '\'': return KeyEvent.VK_QUOTE;

            case SWT.DEL: return KeyEvent.VK_DELETE;
            case SWT.CR: return KeyEvent.VK_ENTER;
            case SWT.ESC: return KeyEvent.VK_ESCAPE;
            case SWT.TAB: return KeyEvent.VK_TAB;
            case SWT.ALT: return KeyEvent.VK_ALT;
            case SWT.SHIFT: return KeyEvent.VK_SHIFT;
            case SWT.CTRL: return KeyEvent.VK_CONTROL;
            case SWT.COMMAND: return KeyEvent.VK_META;
            case SWT.BS: return KeyEvent.VK_BACK_SPACE;
            //case SWT.: return KeyEvent.VK_;

        }
        if (c>=0 && c<255) return c;

        // Guess :G
        return c;
    }

    public static int adaptSWTModifierToAWTModifier(int swtModifier)
    {
        int c = swtModifier;
        int result = 0;

        boolean alt = (c & SWT.ALT) != 0;
        boolean ctrl = (c & SWT.CTRL) != 0;
        boolean shift = (c & SWT.SHIFT) != 0;
        boolean command = (c & SWT.COMMAND) != 0;

        if (alt)         result |= KeyEvent.ALT_DOWN_MASK       | KeyEvent.ALT_MASK;
        if (ctrl)        result |= KeyEvent.CTRL_DOWN_MASK      | KeyEvent.CTRL_MASK;
        if (alt && ctrl) result |= KeyEvent.ALT_GRAPH_DOWN_MASK | KeyEvent.ALT_GRAPH_MASK;
        if (shift)       result |= KeyEvent.SHIFT_DOWN_MASK     | KeyEvent.SHIFT_MASK;
        if (command)     result |= KeyEvent.META_DOWN_MASK      | KeyEvent.META_MASK;

        return result;
    }


}
