/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass.operationsymbols;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.AdditionalColor;
import org.simantics.g2d.element.handler.BorderColor;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.g2d.element.handler.Clickable.PressStatus;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.AdditionalColorImpl;
import org.simantics.g2d.element.handler.impl.BorderColorImpl;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.FixedSize;
import org.simantics.g2d.element.handler.impl.Resizeable;
import org.simantics.g2d.element.handler.impl.StaticTerminals;
import org.simantics.g2d.element.handler.impl.TerminalImpl;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.BoilerSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.BoilerSymbol2;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.ChimneySymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.CompressorSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.ControlValveSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.GeneratorSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.HeatExchangerSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.NoSpinSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.PumpSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.ShutoffValveSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.SwitchSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.Tank2Symbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.TankSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.ThreeWayValveSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.TurbineSymbol;
import org.simantics.g2d.elementclass.operationsymbols.OperationSymbols.VoltageTransformerSymbol;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * Operation symbol handlers.
 * 
 * @author Toni Kalajainen
 */
public class OperationClasses {
    
	static final FillColor FILL_COLOR_HANDLER = FillColorImpl.handlerOf(Color.WHITE);
	static final BorderColor BORDER_COLOR_HANDLER = BorderColorImpl.handlerOf(Color.BLACK);
	static final AdditionalColor ADDITIONAL_COLOR_HANDLER = AdditionalColorImpl.handlerOf(Color.GREEN);
	
	public static final Terminal TERMINAL_IN = new TerminalImpl(); 
	public static final Terminal TERMINAL_OUT = new TerminalImpl(); 
	
	public static ElementClass BOILER_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				BoilerPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(-10, 0, 20, 125),
				StaticTerminals.compile(
						TERMINAL_IN, 	0.0, -BoilerSymbol.DIM*3, DirectionSet.N,
						TERMINAL_OUT, 	0.0,  BoilerSymbol.DIM*3, DirectionSet.S
						)
				);
	public static ElementClass BOILER_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				BoilerPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(-10, 0, 20, 125),
				StaticTerminals.compile(
						TERMINAL_IN,	0.0, -BoilerSymbol.DIM*3, DirectionSet.N,
						TERMINAL_OUT,	0.0,  BoilerSymbol.DIM*3, DirectionSet.S
						)
				);
	public static ElementClass NO_SPIN_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				NoSpinPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(NoSpinSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	0.0, 0.0, DirectionSet.NESW
						)				
				);
	public static ElementClass NO_SPIN_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				NoSpinPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(NoSpinSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	0.0, 0.0, DirectionSet.NESW
						)				
				);			
	public static ElementClass COMPRESSOR_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				CompressorPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(CompressorSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	0.0, 0.0, DirectionSet.NESW
						)				
				);
	public static ElementClass COMPRESSOR_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				CompressorPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(CompressorSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	0.0, 0.0, DirectionSet.NESW
						)				
				);		
	public static ElementClass CONTROLVALVE_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				ControlValvePaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(ControlValveSymbol.BOUNDS),				
				StaticTerminals.compile(
						TERMINAL_IN,	-ControlValveSymbol.D, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 ControlValveSymbol.D, 0.0, DirectionSet.S
						)				
				);	
	public static ElementClass CONTROLVALVE_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				ControlValvePaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(ControlValveSymbol.BOUNDS),				
				StaticTerminals.compile(
						TERMINAL_IN,	-ControlValveSymbol.D, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 ControlValveSymbol.D, 0.0, DirectionSet.S
						)				
				);		
	public static ElementClass THREEWAYVALVE_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				ThreeWayValvePaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(ControlValveSymbol.BOUNDS),				
				StaticTerminals.compile(
						TERMINAL_IN,	-ThreeWayValveSymbol.D, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 ThreeWayValveSymbol.D, 0.0, DirectionSet.S
						)				
				);	
	public static ElementClass THREEWAYVALVE_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				ThreeWayValvePaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(ControlValveSymbol.BOUNDS),				
				StaticTerminals.compile(
						TERMINAL_IN,	-ThreeWayValveSymbol.D, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 ThreeWayValveSymbol.D, 0.0, DirectionSet.S
						)				
				);		
	public static ElementClass HEATEXCHANGER_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				HeatExchangerPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(HeatExchangerSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	HeatExchangerSymbol.BOUNDS.getMinX(), HeatExchangerSymbol.BOUNDS.getMaxY()*0.5, DirectionSet.SW,
						TERMINAL_OUT,	HeatExchangerSymbol.BOUNDS.getMaxX(), HeatExchangerSymbol.BOUNDS.getMinY()*0.5, DirectionSet.NE
						)								
				);	
	public static ElementClass HEATEXCHANGER_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				HeatExchangerPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(HeatExchangerSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	HeatExchangerSymbol.BOUNDS.getMinX(), HeatExchangerSymbol.BOUNDS.getMaxY(), DirectionSet.SW,
						TERMINAL_OUT,	HeatExchangerSymbol.BOUNDS.getMaxX(), HeatExchangerSymbol.BOUNDS.getMinY(), DirectionSet.NE						
						)								
				);		
	public static ElementClass PUMP_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				PumpPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(PumpSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	-PumpSymbol.D2, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 PumpSymbol.D2, 0.0, DirectionSet.S
						)					
				);
	public static ElementClass PUMP_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				PumpPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(PumpSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	-PumpSymbol.D2, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 PumpSymbol.D2, 0.0, DirectionSet.S
						)					
				);	
	public static ElementClass SHUTOFFVALVE_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				ShutoffValvePaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(ShutoffValveSymbol.SHAPE.getBounds()),
				StaticTerminals.compile(
						TERMINAL_IN,	-ShutoffValveSymbol.DIM, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 ShutoffValveSymbol.DIM, 0.0, DirectionSet.S
						)					
				);	
	public static ElementClass SHUTOFFVALVE_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				ShutoffValvePaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(ShutoffValveSymbol.SHAPE.getBounds()),
				StaticTerminals.compile(
						TERMINAL_IN,	-ShutoffValveSymbol.DIM, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 ShutoffValveSymbol.DIM, 0.0, DirectionSet.S
						)					
				);		
	public static ElementClass SWITCH_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				SwitchPaint.INSTANCE,
				BORDER_COLOR_HANDLER,
				FixedSize.of(SwitchSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	SwitchSymbol.BOUNDS.getCenterX(), SwitchSymbol.BOUNDS.getMinY(), DirectionSet.N,
						TERMINAL_OUT,	SwitchSymbol.BOUNDS.getCenterX(), SwitchSymbol.BOUNDS.getMaxY(), DirectionSet.S						
						)					
				);	
	public static ElementClass SWITCH_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				SwitchPaint.INSTANCE,
				BORDER_COLOR_HANDLER,
				FixedSize.of(SwitchSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	SwitchSymbol.BOUNDS.getCenterX(), SwitchSymbol.BOUNDS.getMinY(), DirectionSet.N,
						TERMINAL_OUT,	SwitchSymbol.BOUNDS.getCenterX(), SwitchSymbol.BOUNDS.getMaxY(), DirectionSet.S						
						)					
				);		
	public static ElementClass TURBINE_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				TurbinePaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(TurbineSymbol.SHAPE.getBounds()),
				StaticTerminals.compile(
						TERMINAL_IN,	-TurbineSymbol.DIM, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 TurbineSymbol.DIM, 0.0, DirectionSet.S
						)						
				);		
	public static ElementClass TURBINE_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				TurbinePaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(TurbineSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	-TurbineSymbol.DIM, 0.0, DirectionSet.N,
						TERMINAL_OUT,	 TurbineSymbol.DIM, 0.0, DirectionSet.S
						)						
				);		
	public static ElementClass VOLTAGETRANSFORMER_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				VoltageTransformerPaint.INSTANCE,
				ADDITIONAL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(VoltageTransformerSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	VoltageTransformerSymbol.BOUNDS.getCenterX(), VoltageTransformerSymbol.BOUNDS.getMinY(), DirectionSet.N,
						TERMINAL_OUT, 	VoltageTransformerSymbol.BOUNDS.getCenterX(), VoltageTransformerSymbol.BOUNDS.getMaxY(), DirectionSet.S
						)							
				);
	public static ElementClass VOLTAGETRANSFORMER_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				VoltageTransformerPaint.INSTANCE,
				ADDITIONAL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(VoltageTransformerSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	VoltageTransformerSymbol.BOUNDS.getCenterX(), VoltageTransformerSymbol.BOUNDS.getMinY(), DirectionSet.N,
						TERMINAL_OUT,	VoltageTransformerSymbol.BOUNDS.getCenterX(), VoltageTransformerSymbol.BOUNDS.getMaxY(), DirectionSet.S
						)							
				);	
	public static ElementClass CHIMNEY_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				ChimneyPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(ChimneySymbol.BOUNDS)
				);		
	public static ElementClass CHIMNEY_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				ChimneyPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(ChimneySymbol.BOUNDS)
				);		
	public static ElementClass GENERATOR_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				GeneratorPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(GeneratorSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	-GeneratorSymbol.DIM, 0.0, DirectionSet.W,
						TERMINAL_OUT,	 GeneratorSymbol.DIM, 0.0, DirectionSet.E
						)								
				);		
	public static ElementClass GENERATOR_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				GeneratorPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				FixedSize.of(GeneratorSymbol.BOUNDS),
				StaticTerminals.compile(
						TERMINAL_IN,	-GeneratorSymbol.DIM, 0.0, DirectionSet.W,
						TERMINAL_OUT,	 GeneratorSymbol.DIM, 0.0, DirectionSet.E
						)												
				);
	public static ElementClass TANK_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				TankPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				Resizeable.initialSize(40, 15)
				);		
	public static ElementClass TANK_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				TankPaint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				Resizeable.initialSize(40, 15)
				);		
	public static ElementClass TANK2_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				Tank2Paint.INSTANCE,
				FILL_COLOR_HANDLER,
				BORDER_COLOR_HANDLER,
				ADDITIONAL_COLOR_HANDLER,				
				Resizeable.initialSize(40, 15)
				);		
	public static ElementClass TANK2_BUTTON_CLASS =
		ElementClass.compile(
				Clickable.INSTANCE,
				DefaultTransform.INSTANCE,
				Tank2Paint.INSTANCE,
				FILL_COLOR_HANDLER,
				ADDITIONAL_COLOR_HANDLER,				
				BORDER_COLOR_HANDLER,
				Resizeable.initialSize(40, 15)
				);		
	
	
	
	public static class BoilerPaint implements SceneGraph {		

		private static final long serialVersionUID = -4545277680608759806L;
		public static final BoilerPaint INSTANCE = new BoilerPaint();
		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
	       G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
	       if (node == null) {
	           node = parent.addNode(G2DParentNode.class);
	           e.setHint(SG_NODE, node);
	       }
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new BoilerSymbol2(fc, bc, OperationSymbols.BOILER_HES);
			} else {
				ps = OperationSymbols.BOILER_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL) 
//					gc.getGraphics2D().translate(-2, -3);
			}
			
			ps.init(node);
		}
	}
	
	
	public static class NoSpinPaint implements SceneGraph {

		private static final long serialVersionUID = 801958319361745846L;
		public static final NoSpinPaint INSTANCE = new NoSpinPaint();
		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
	       G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
	       if (node == null) {
	           node = parent.addNode(G2DParentNode.class);
	           e.setHint(SG_NODE, node);
	       }
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new NoSpinSymbol(fc, bc);
			} else {
				ps = OperationSymbols.NO_SPIN_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			
			ps.init(node);
		}
	}

	
	public static class ControlValvePaint implements SceneGraph {

		private static final long serialVersionUID = -8208633777668762027L;
		public static final ControlValvePaint INSTANCE = new ControlValvePaint();
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
	       G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
	       if (node == null) {
	           node = parent.addNode(G2DParentNode.class);
	           e.setHint(SG_NODE, node);
	       }
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new ControlValveSymbol(fc, bc);
			} else {
				ps = OperationSymbols.CONTROLVALVE_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			
			ps.init(node);
		}
	}	
	
	public static class ThreeWayValvePaint implements SceneGraph {

		private static final long serialVersionUID = -1848763601182093048L;
		public static final ThreeWayValvePaint INSTANCE = new ThreeWayValvePaint();
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
	       G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
	       if (node == null) {
	           node = parent.addNode(G2DParentNode.class);
	           e.setHint(SG_NODE, node);
	       }
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new ThreeWayValveSymbol(fc, bc);
			} else {
				ps = OperationSymbols.THREEWAYVALVE_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			
			ps.init(node);
		}
	}	
	
	public static class HeatExchangerPaint implements SceneGraph {

		private static final long serialVersionUID = -5482316746105556083L;
		public static final HeatExchangerPaint INSTANCE = new HeatExchangerPaint();		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
	       G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
	       if (node == null) {
	           node = parent.addNode(G2DParentNode.class);
	           e.setHint(SG_NODE, node);
	       }
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new HeatExchangerSymbol(fc, bc);
			} else {
				ps = OperationSymbols.HEATEXCHANGER_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			
			ps.init(node);
		}
	}	
		
	
	
	public static class PumpPaint implements SceneGraph {

		private static final long serialVersionUID = 5899800511420262337L;
		public static final PumpPaint INSTANCE = new PumpPaint();		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
	       G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
	       if (node == null) {
	           node = parent.addNode(G2DParentNode.class);
	           e.setHint(SG_NODE, node);
	       }
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new PumpSymbol(fc, bc);
			} else {
				ps = OperationSymbols.PUMP_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			
			ps.init(node);
		}
	}	
	
	
	public static class ShutoffValvePaint implements SceneGraph {

		private static final long serialVersionUID = 6258753947743405959L;
		public static final ShutoffValvePaint INSTANCE = new ShutoffValvePaint();		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
	       G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
	       if (node == null) {
	           node = parent.addNode(G2DParentNode.class);
	           e.setHint(SG_NODE, node);
	       }
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new ShutoffValveSymbol(fc, bc);
			} else {
				ps = OperationSymbols.SHUTOFFVALVE_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			
			ps.init(node);
		}
	}	
	
	
	
	public static class SwitchPaint implements SceneGraph {

		private static final long serialVersionUID = -171980746141963729L;
		public static final SwitchPaint INSTANCE = new SwitchPaint();
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
			G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
			if (node == null) {
				node = parent.addNode(G2DParentNode.class);
				e.setHint(SG_NODE, node);
			}
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new SwitchSymbol(bc);
			} else {
				ps = OperationSymbols.SWITCH_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			ps.init(node);
		}
	}		

	
	public static class TurbinePaint implements SceneGraph {

		private static final long serialVersionUID = -920598007509848402L;
		public static final TurbinePaint INSTANCE = new TurbinePaint();		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
			G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
			if (node == null) {
				node = parent.addNode(G2DParentNode.class);
				e.setHint(SG_NODE, node);
			}
			
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new TurbineSymbol(bc, fc);
			} else {
				ps = OperationSymbols.TURBINE_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			ps.init(node);
		}
	}		

	public static class CompressorPaint implements SceneGraph {

		private static final long serialVersionUID = 6961201125549409431L;
		public static final CompressorPaint INSTANCE = new CompressorPaint();		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
			G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
			if (node == null) {
				node = parent.addNode(G2DParentNode.class);
				e.setHint(SG_NODE, node);
			}
			
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new CompressorSymbol(bc, fc);
			} else {
				ps = OperationSymbols.COMPRESSOR_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			ps.init(node);
		}
	}	
	
	public static class VoltageTransformerPaint implements SceneGraph {

		private static final long serialVersionUID = -4935588203299292629L;
		public static final VoltageTransformerPaint INSTANCE = new VoltageTransformerPaint();		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
			G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
			if (node == null) {
				node = parent.addNode(G2DParentNode.class);
				e.setHint(SG_NODE, node);
			}
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 		color1 		= ElementUtils.getBorderColor(e);
			Color 		color2 		= ElementUtils.getAdditionalColor(e);
			if (color1==null || color2==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new VoltageTransformerSymbol(color1, color2);
			} else {
				ps = OperationSymbols.VOLTAGETRANSFORMER_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			ps.init(node);
		}
	}		
	
	public static class ChimneyPaint implements SceneGraph {

		private static final long serialVersionUID = 1001249555587430505L;
		public static final ChimneyPaint INSTANCE = new ChimneyPaint();		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
			G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
			if (node == null) {
				node = parent.addNode(G2DParentNode.class);
				e.setHint(SG_NODE, node);
			}
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			if (bc==null) return;
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new ChimneySymbol(fc, bc);
			} else {
				ps = OperationSymbols.CHIMNEY_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			ps.init(node);
		}
	}		
	
	public static class GeneratorPaint implements SceneGraph {

		private static final long serialVersionUID = -1080419588160841727L;
		public static final GeneratorPaint INSTANCE = new GeneratorPaint();		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
			G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
			if (node == null) {
				node = parent.addNode(G2DParentNode.class);
				e.setHint(SG_NODE, node);
			}
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new GeneratorSymbol(fc, bc);
			} else {
				ps = OperationSymbols.GENERATOR_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			ps.init(node);
		}
	}		
	
	public static class TankPaint implements SceneGraph {

		private static final long serialVersionUID = -461979630655554477L;
		public static final TankPaint INSTANCE = new TankPaint();		
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
			G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
			if (node == null) {
				node = parent.addNode(G2DParentNode.class);
				e.setHint(SG_NODE, node);
			}
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			Rectangle2D		bounds	= ElementUtils.getElementBounds(e);
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new TankSymbol(bounds, 5.0, bc, fc);
			} else {
				ps = OperationSymbols.TANK_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			ps.init(node);
		}
	}
	
	public static class Tank2Paint implements SceneGraph {

		private static final long serialVersionUID = 5232349098800595743L;
		public static final Tank2Paint INSTANCE = new Tank2Paint();
	    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

		@Override
		public void cleanup(IElement e) {
	       Node node = e.removeHint(SG_NODE);
	       if (node != null)
	           node.remove();
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
			G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
			if (node == null) {
				node = parent.addNode(G2DParentNode.class);
				e.setHint(SG_NODE, node);
			}
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

			Color 			fc 		= ElementUtils.getFillColor(e);
			Color 			bc 		= ElementUtils.getBorderColor(e);
			Color 			ac 		= ElementUtils.getAdditionalColor(e);
			Rectangle2D		bounds	= ElementUtils.getElementBounds(e);
			PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			Image ps 		= null;
			
			if (press==null) {
				ps = new Tank2Symbol(bounds, 5.0, bc, fc, ac);
			} else {
				ps = OperationSymbols.TANK2_SHADOW;
// ?????????				
//				if (press==PressStatus.NORMAL)
//					gc.getGraphics2D().translate(-2, -3);
			}
			ps.init(node);
		}
	}	
	
}