/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass.canvas;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ClippingNode;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * An element handler that "paints" a canvas bound to an element.
 * 
 * Keys: CanvasClass.KEY_CANVAS
 * 
 * @author Toni Kalajainen
 */
public class CanvasPainter implements SceneGraph {

    private static final long         serialVersionUID = -182067379834789790L;

    public static final CanvasPainter INSTANCE         = new CanvasPainter();

    public static final Key           SG_NODE          = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

    @Override
    public void cleanup(IElement e) {
        ElementUtils.removePossibleNode(e, SG_NODE);
    }

    @Override
    public void init(IElement e, G2DParentNode parent) {
        ICanvasContext ctx = e.getHint(CanvasClass.KEY_CANVAS);
        if (ctx == null) {
            ElementUtils.removePossibleNode(e, SG_NODE);
            return;
        }

        ClippingNode node = ElementUtils.getOrCreateNode(e, parent, SG_NODE, ClippingNode.class);

        Rectangle2D bounds = ElementUtils.getElementBounds(e);
        node.setClip(bounds);
    }

}
