/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.diagram.handler.PickRequest.PickPolicy;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.cache.StaticProvider;

/**
 * Handles pick and painting of paintable symbols
 * 
 * @author Toni Kalajainen
 */
public class PaintableSymbolHandler implements SceneGraph, Pick, InternalSize {

    private static final long serialVersionUID = 8612101011132309291L;

    private final Rectangle2D rect;
    private final Double ratio;
    private final Image ps;

    private final IProvider<Image> symbolProvider;

    public PaintableSymbolHandler(Image symbol)
    {
        this.symbolProvider = StaticProvider.provide(symbol);
        ps = symbolProvider.get();
        rect = ps.getBounds();
        ratio = rect.getWidth() / rect.getHeight();
    }

    public PaintableSymbolHandler(IProvider<Image> symbolProvider)
    {
        this.symbolProvider = symbolProvider;
        ps = symbolProvider.get();
        rect = ps.getBounds();
        ratio = rect.getWidth() / rect.getHeight();
    }


    @Override
    public void cleanup(IElement e) {
    }

    @Override
    public void init(IElement e, G2DParentNode parent) {
        System.out.println("PaintableSymbolHandler.paint()");
//      Graphics2D g = elementGC.getGraphics2D();
//      Image ps = ctx.getSingleItem(SymbolUtil.class).get(symbolProvider, g.getDeviceConfiguration());
//      ps.paint(elementGC);
    }

    @Override
    public boolean pickTest(IElement e, Shape s, PickPolicy policy) {
        Shape outline = ps.getOutline();
        if (policy == PickPolicy.PICK_CONTAINED_OBJECTS)
            return GeometryUtils.contains(s, outline);
        if (policy == PickPolicy.PICK_INTERSECTING_OBJECTS)
            return GeometryUtils.intersects(s, outline);
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        if (size==null) size = new Rectangle2D.Double();
        size.setFrame(rect);
        return size;
    }

}
