/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.FixedSize;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextPainter;

/**
 * TODO Add horiz, vert alignment
 * 
 * @author Toni Kalajainen
 */
public class LabelClass {

    public static final ElementClass CLASS =
        ElementClass.compile(
                TextColorImpl.BLACK,
                DefaultTransform.INSTANCE,
                FixedSize.of(100, 20),
                Text.INSTANCE,
                new TextPainter()
                //new RotatorHandler()
        );



    static class TextSize implements InternalSize {
        private static final long serialVersionUID = 7358363139299763075L;

        @Override
        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            // FontRenderContext is required !!?!
            return null;
        }
    }

}
