/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Single;
import org.simantics.g2d.element.handler.ElementHandler;

/**
 * @author Tuukka Lehtonen
 */
@Single
public interface FlagHandler extends ElementHandler {

    FlagClass.Type getType(IElement e);
    void setType(IElement e, FlagClass.Type type);

    boolean isExternal(IElement e);
    /**
     * A flag can be set as external only when it is not connected.
     * 
     * @param e
     * @param external
     * @return
     */
    void setExternal(IElement e, boolean external);

    void connect(IElement e1, IElement e2);

    /**
     * @param e1 the element to connect
     * @param o1 the back-end object of e1
     * @param o2 the other object o1 is connected to or <code>null</code> if
     *        disconnected
     */
    void connectData(IElement e1, Object o1, Object o2);

    FlagClass.Connection<IElement> getConnection(IElement e);
    FlagClass.Connection<Object> getConnectionData(IElement e);

    void disconnect(IElement e);

    boolean isWithinDiagram(IDiagram d, FlagClass.Connection<?> c);
    IElement getCorrespondence(IElement end);

}
