/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Resize;

/**
 * @author Toni Kalajainen
 */
public class ProxyResize implements Resize {

    private static final long serialVersionUID = 6930857496618718630L;

    Resize orig;
    IProxyProvider provider;

    public ProxyResize(IProxyProvider provider, Resize orig) {
        this.provider = provider;
        this.orig = orig;
    }	

    @Override
    public Double getFixedAspectRatio(IElement e) {
        return orig.getFixedAspectRatio(provider.provide(e));
    }

    @Override
    public Rectangle2D getMaximumSize(IElement e) {
        return orig.getMaximumSize(provider.provide(e));
    }

    @Override
    public Rectangle2D getMinimumSize(IElement e) {
        return orig.getMinimumSize(provider.provide(e));
    }

    @Override
    public void resize(IElement e, Rectangle2D newSize) {
        orig.resize(provider.provide(e), newSize);
    }

    @Override
    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        return orig.getBounds(e, size);
    }

}
