/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.util.ArrayList;
import java.util.List;

import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.AdditionalColor;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.BorderColor;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.ElementAdapter;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.HandleMouseEvent;
import org.simantics.g2d.element.handler.Heartbeat;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.Rotate;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.element.handler.Stateful;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.TextColor;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.handler.Validator;

/**
 * @author Toni Kalajainen
 */
public class ProxyHandler {

    public static ElementClass getProxyClass(ElementClass clazz, IProxyProvider prov)
    {
        List<ElementHandler> result = new ArrayList<ElementHandler>();
        for (ElementHandler eh : clazz.getAll())
        {
            addProxyElementHandlers(eh, prov, result);
            result.add(eh);
        }
        return ElementClass.compile(result);
    }

    public static void addProxyElementHandlers(ElementHandler eh, IProxyProvider prov, List<ElementHandler> result)
    {
        if (eh instanceof Move) result.add(new ProxyMove(prov, (Move)eh));
        if (eh instanceof Stateful) result.add(new ProxyEnabled(prov, (Stateful)eh));
        if (eh instanceof Clickable) result.add(new ProxyClickable(prov, (Clickable)eh));
        if (eh instanceof InternalSize) result.add( new ProxyBounds(prov, (InternalSize)eh) );
        if (eh instanceof Resize) result.add( new ProxyResize(prov, (Resize)eh) );
        if (eh instanceof Outline) result.add( new ProxyElementShape(prov, (Outline)eh) );
        if (eh instanceof FillColor) result.add(new ProxyFillColor(prov, (FillColor)eh));
        if (eh instanceof BorderColor) result.add(new ProxyBorderColor(prov, (BorderColor)eh));
        if (eh instanceof TextColor) result.add(new ProxyTextColor(prov, (TextColor)eh));
        if (eh instanceof AdditionalColor) result.add(new ProxyAdditionalColor(prov, (AdditionalColor)eh));
        if (eh instanceof BendsHandler) result.add(new ProxyEdgeBends(prov, (BendsHandler)eh));
        if (eh instanceof EdgeVisuals) result.add(new ProxyEdgeVisuals(prov, (EdgeVisuals)eh));
        if (eh instanceof ElementAdapter) result.add(new ProxyElementAdapter(prov, (ElementAdapter)eh));
        if (eh instanceof HandleMouseEvent) result.add(new ProxyHandleMouseEvent(prov, (HandleMouseEvent)eh));
        if (eh instanceof LifeCycle) result.add(new ProxyLifeCycle(prov, (LifeCycle)eh));
        if (eh instanceof TerminalTopology) result.add(new ProxyNode(prov, (TerminalTopology)eh));
        if (eh instanceof Pick) result.add(new ProxyPick(prov, (Pick)eh));
        if (eh instanceof Rotate) result.add(new ProxyRotate(prov, (Rotate)eh));
        if (eh instanceof Scale) result.add(new ProxyScale(prov, (Scale)eh));
        if (eh instanceof TerminalLayout) result.add(new ProxyTerminalHandler(prov, (TerminalLayout)eh));
        if (eh instanceof Text) result.add(new ProxyText(prov, (Text)eh));
        if (eh instanceof Transform) result.add(new ProxyTransform(prov, (Transform)eh));
        if (eh instanceof Validator) result.add(new ProxyValidator(prov, (Validator)eh));
        if (eh instanceof Heartbeat) result.add(new ProxyHeartbeat(prov, (Heartbeat)eh));
    }

}
