/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.InternalSize;

/**
 * @author Toni Kalajainen
 */
public class ProxyBounds implements InternalSize {

    private static final long serialVersionUID = -6722317220092257275L;

    InternalSize orig;
    IProxyProvider provider;

    public ProxyBounds(IProxyProvider provider, InternalSize orig) {
        this.provider = provider;
        this.orig = orig;
    }	

    @Override
    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        return orig.getBounds(provider.provide(e), size);
    }

}
