/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.Color;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BorderColor;

/**
 * @author Toni Kalajainen
 */
public class ProxyBorderColor implements BorderColor {

	private static final long serialVersionUID = -5915494705662754786L;
	BorderColor orig;
	IProxyProvider provider;
	
	public ProxyBorderColor(IProxyProvider provider, BorderColor orig) {
		this.provider = provider;
		this.orig = orig;
	}

	@Override
	public Color getBorderColor(IElement e) {
		return orig.getBorderColor(provider.provide(e));
	}

	@Override
	public void setBorderColor(IElement e, Color c) {
		orig.setBorderColor(provider.provide(e), c);
	}

}
