/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.image.Image;

/**
 * A {@link StaticSymbol} implementation that provides a single static image
 * provided to it during construction.
 */
public class StaticSymbolImpl implements StaticSymbol {

    private static final long serialVersionUID = 9062542343545213793L;

    private final Image i;

    public StaticSymbolImpl(Image i) {
        if (i == null)
            throw new IllegalArgumentException("null arg");
        this.i = i;
    }

    @Override
    public Image getImage() {
        return i;
    }

    @Override
    public int hashCode() {
        return i.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        StaticSymbolImpl other = (StaticSymbolImpl) obj;
        return i.equals(other.i);
    }

}
