/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.util.Objects;

import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.Adapter;

/**
 * A generic single object adapter handler for use with {@link ElementClass}.
 * 
 * @author Tuukka Lehtonen
 */
public class StaticObjectAdapter implements Adapter {

    private static final long serialVersionUID = -8713272704786672656L;

    private final Object object;

    public StaticObjectAdapter(Object object) {
        if (object == null)
            throw new IllegalArgumentException("null object");
        this.object = object;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T adapt(Class<T> toClass) {
        if (toClass == null)
            throw new IllegalArgumentException("null class");
        if (toClass.isInstance(object))
            return (T) object;
        return null;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(object);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        StaticObjectAdapter other = (StaticObjectAdapter) obj;
        return Objects.equals(object, other.object);
    }

}