/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.Stroke;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;

/**
 * Edge visuals that are the same for all edges of the class.
 * 
 * @author Toni Kalajainen
 */
public class StaticEdgeVisuals implements EdgeVisuals {

    private static final long serialVersionUID = -2263869759801224096L;

    public static final StaticEdgeVisuals DEFAULT_EDGE_VISUALS =
        new StaticEdgeVisuals(ArrowType.None, ArrowType.Stroke, ConfigurableEdgeVisuals.DEFAULT_STROKE, 3.0, 3.0);

    ArrowType beginArrow, endArrow;
    Stroke stroke;
    StrokeType strokeType;
    double beginArrowSize, endArrowSize;

    public StaticEdgeVisuals(ArrowType beginArrow, ArrowType endArrow, Stroke stroke, double beginArrowSize, double endArrowSize)
    {
        this.beginArrow = beginArrow;
        this.endArrow = endArrow;
        this.stroke = stroke;
        this.strokeType = StrokeType.Relative;
        this.beginArrowSize = beginArrowSize;
        this.endArrowSize = endArrowSize;
    }

    @Override
    public ArrowType getArrowType(IElement e, EdgeEnd end) {
        if (end==EdgeEnd.Begin)
            return beginArrow;
        if (end==EdgeEnd.End)
            return beginArrow;
        throw new RuntimeException();
    }

    @Override
    public StrokeType getStrokeType(IElement e) {
        return strokeType;
    }

    @Override
    public Stroke getStroke(IElement e) {
        return stroke;
    }

    @Override
    public void setArrowType(IElement e, EdgeEnd end, ArrowType arrowType) {
        throw new RuntimeException("Cannot modify static edge visuals");
    }

    @Override
    public void setStroke(IElement e, Stroke s) {
        throw new RuntimeException("Cannot modify static edge visuals");
    }

    @Override
    public void setStrokeType(IElement e, StrokeType t) {
        throw new RuntimeException("Cannot modify static edge visuals");
    }

    @Override
    public double getArrowSize(IElement e, EdgeEnd end) {
        if (end == EdgeEnd.Begin)
            return beginArrowSize;
        if (end==EdgeEnd.End)
            return endArrowSize;
        return 0;
    }

    @Override
    public void setArrowSize(IElement e, EdgeEnd end, double size) {
        throw new RuntimeException("Cannot modify arrow size");
    }


}
