/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.util.Collections;
import java.util.Set;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementLayers;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayers;

/**
 * @author Antti Villberg
 */
public class SimpleElementLayers implements ElementLayers {

    public static final SimpleElementLayers INSTANCE = new SimpleElementLayers();

    private static final long serialVersionUID = 379502115902223354L;

    @Override
    public boolean isVisible(IElement e, ILayers layers) {

        assert (e != null);
        assert (layers != null);

        Set<ILayer> elementLayers = (Set<ILayer>) e.getHint(ElementHints.KEY_VISIBLE_LAYERS);
        if (elementLayers == null)
            return true;

        return !Collections.disjoint(layers.getVisibleLayers(), elementLayers);

    }

    @Override
    public boolean isVisible(IElement e, ILayer layer) {

        Set<ILayer> elementLayers = (Set<ILayer>) e.getHint(ElementHints.KEY_VISIBLE_LAYERS);
        if (elementLayers == null)
            return true;

//		System.out.println("Testing: '" + layer.getName() + "'");
//		for(ILayer l : elementLayers) System.out.println("elementLayer: '" + l.getName() + "'");
//		System.out.println("result = " + elementLayers.contains(layer));

        return elementLayers.contains(layer);

    }

    @Override
    public boolean isFocusable(IElement e, ILayers layers) {

        assert (e != null);
        assert (layers != null);

        Set<ILayer> elementLayers = (Set<ILayer>) e.getHint(ElementHints.KEY_FOCUS_LAYERS);
        if (elementLayers == null)
            return true;

        return !Collections.disjoint(layers.getVisibleLayers(), elementLayers);

    }

    @Override
    public boolean isFocusable(IElement e, ILayer layer) {

        Set<ILayer> elementLayers = (Set<ILayer>) e.getHint(ElementHints.KEY_FOCUS_LAYERS);
        if (elementLayers == null)
            return true;

        return elementLayers.contains(layer);

    }

}
