/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.element.handler.Validator;

/**
 * Handler for an element that can be freely scaled.
 * 
 * @author Toni Kalajainen
 */
public class Scaleable implements Scale, Validator {

    private static final long serialVersionUID = -4033716332747863703L;

    Double aspectRatio;

    public Scaleable(Double aspectRatio)
    {
        this.aspectRatio = aspectRatio;
    }

    @Override
    public Double getFixedAspectRatio(IElement e) {
        return aspectRatio;
    }

    @Override
    public Point2D getScale(IElement e) {
        AffineTransform at = e.getHint(ElementHints.KEY_TRANSFORM);
        return _getScale(at);
    }	

    @Override
    public void setScale(IElement e, Point2D newScale) {
        Point2D oldScale = getScale(e);
        double sx = newScale.getX() / oldScale.getX();
        double sy = newScale.getY() / oldScale.getY();
        AffineTransform at = e.getHint(ElementHints.KEY_TRANSFORM);
        at = new AffineTransform(at);
        at.scale(sx, sy);
        e.setHint(ElementHints.KEY_TRANSFORM, at);
    }

    @Override
    public Point2D getMaximumScale(IElement e) {
        return null;
    }

    @Override
    public Point2D getMinimumScale(IElement e) {
        return null;
    }

    private static Point2D _getScale(AffineTransform at) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        // Project unit vector to canvas
        double sx = Math.sqrt( m00*m00+m10*m10 );
        double sy = Math.sqrt( m01*m01+m11*m11 );
        return new Point2D.Double(sx, sy);
    }

    @Override
    public void validate(final IElement e, final ICanvasContext ctx, Collection<Issue> lst) {
        /*
		if (aspectRatio!=null)
		{
			// Validate aspect ratio
			final Point2D scale = getScale(e);
			double currentRatio = scale.getX() / scale.getY();
			if (Math.abs(currentRatio - aspectRatio)>0.000001)
			{
				lst.add(new Issue() {
					@Override
					public String getMessage() {
						return "Aspect ratio is wrong";
					}
					@Override
					public void addSuggestions(Collection<Suggestion> suggestionList) {
						suggestionList.add(new Suggestion() {
							@Override
							public boolean fix() {
								double newSx = scale.getX();
								double newSy = newSx * aspectRatio;
								Point2D newScale = new Point2D.Double(newSx, newSy);
								setScale(e, newScale);
								ctx.setDirty();
								return true;
							}
							@Override
							public String getMessage() {
								return "Scale height, keep width";
							}});
					}});
			}
			// TODO min scale validator
			// TODO max scale validator
		}
         */
    }


}
