/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Rotate;

/**
 * @author Toni Kalajainen
 */
public class Rotateable implements Rotate {

    private static final long serialVersionUID = -1218542543108449939L;

    public static final Rotateable HANDLER = new Rotateable();

    @Override
    public void rotate(IElement e, double theta, Point2D origo) {
        if (Double.isNaN(theta)) return;
        AffineTransform at = e.getHint(ElementHints.KEY_TRANSFORM);
        at = (AffineTransform) at.clone();
        at.rotate(theta, origo.getX(), origo.getY());
        e.setHint(ElementHints.KEY_TRANSFORM, at);
    }

    @Override
    public double getAngle(IElement e) {
        AffineTransform at = e.getHint(ElementHints.KEY_TRANSFORM);
        double m01 = at.getShearX();
        double m11 = at.getScaleY();
        return -Math.atan2(m01, m11);
    }

}
