/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Parent;

/**
 * The most simple implementation of the {@link Parent} handler.
 * 
 * @author Tuukka Lehtonen
 */
public class ParentImpl implements Parent {

    public static final ParentImpl INSTANCE = new ParentImpl();

    private static final long serialVersionUID = 1L;

    private ParentImpl() {}

    /* (non-Javadoc)
     * @see org.simantics.g2d.element.handler.Parent#getParent(org.simantics.g2d.element.IElement)
     */
    @Override
    public IElement getParent(IElement element) {
        IElement e = element.getHint(ElementHints.KEY_PARENT_ELEMENT);
        return e;

//        if (e == null)
//            return null;
//
//        Object obj = e.getHint(ElementHints.KEY_OBJECT);
//        if (obj == null)
//            return e;
//
//        IDiagram diagram = ElementUtils.peekDiagram(element);
//        DataElementMap dem = diagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
//        if (dem == null)
//            return e;
//
//        IElement mapped = dem.getElement(diagram, obj);
//        return mapped != null ? mapped : e;
    }

}
