/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.List;

import org.simantics.g2d.diagram.handler.PickRequest.PickPolicy;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.utils.GeometryUtils;

/**
 * @author Tuukka Lehtonen
 */
public class OutlinePick implements Pick {

    public static final ElementHandler INSTANCE         = new OutlinePick();

    private static final long          serialVersionUID = 1L;

    @Override
    public boolean pickTest(IElement e, Shape s, PickPolicy policy) {
        Rectangle2D pickArea = null;
        if (s instanceof Rectangle2D)
            pickArea = (Rectangle2D) s;
        else
            // FIXME: suboptimal, but works.
            pickArea = s.getBounds2D();

        // Pick with shape handler(s)
        List<Outline> shapeHandlers = e.getElementClass().getItemsByClass(Outline.class);
        if (!shapeHandlers.isEmpty()) {
            // Convert pick shape to element coordinates
            Transform t = e.getElementClass().getSingleItem(Transform.class);
            AffineTransform canvasToElement = t.getTransform(e);
            AffineTransform elementToCanvas;
            try {
                elementToCanvas = canvasToElement.createInverse();
            } catch (NoninvertibleTransformException e1) {
                throw new RuntimeException(e1);
            }
            Shape pickShapeInElementCoords = GeometryUtils.transformShape(pickArea, elementToCanvas);

            // Intersection with one shape is enough
            switch (policy) {
                case PICK_INTERSECTING_OBJECTS: {
                    for (Outline es : shapeHandlers) {
                        Shape elementShape = es.getElementShape(e);
                        if (elementShape == null)
                            return false;
                        if (GeometryUtils.intersects(pickShapeInElementCoords, elementShape))
                            return true;
                    }
                    return false;
                }
                case PICK_CONTAINED_OBJECTS: {
                    for (Outline es : shapeHandlers) {
                        Shape elementShape = es.getElementShape(e);
                        if (GeometryUtils.contains(pickShapeInElementCoords, elementShape))
                            return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }
}
