/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ParentTransform;
import org.simantics.g2d.element.handler.Transform;

/**
 * This class implements Transform, Move, Rotate, and Scale.
 * It maintains element position in element variable ElementHints.KEY_TRANSFORM.
 * 
 * @author Toni Kalajainen
 */
public class ElementParentTransform implements ParentTransform {

    public static final ElementParentTransform INSTANCE = new ElementParentTransform();

    private static final long serialVersionUID = 2381541967701117513L;

	@Override
	public AffineTransform getTransform(IElement e) {
	    
	    IElement parentElement = e.getHint(ElementHints.KEY_PARENT_ELEMENT);
	    if(parentElement == null) return null;
	    
        Transform parentTransform = parentElement.getElementClass().getSingleItem(Transform.class);
        assert(parentTransform!=null);
        
        AffineTransform result = parentTransform.getTransform(parentElement);
        return result;
        
	}

	public void setParent(IElement e, IElement parent) {
		e.setHint(ElementHints.KEY_PARENT_ELEMENT, parent);
	}

}
