/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.util.Map;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Parameters;

/**
 * @author Antti Villberg
 * @since 1.31.0
 */
public class DefaultParameters implements Parameters {

	private static final long serialVersionUID = -9138310692519364097L;

	public static final DefaultParameters INSTANCE = new DefaultParameters();

	@Override
	public Map<String, Object> getParameters(IElement e) {
		return e.getHint(ElementHints.KEY_PARAMETERS);
	}

	@Override
	public void setParameters(IElement e, Map<String, Object> p) {
		if (p != null) {
			e.setHint(ElementHints.KEY_PARAMETERS, p);
		} else {
			e.removeHint(ElementHints.KEY_PARAMETERS);
		}
	}

}
