/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.Color;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BorderColor;
import org.simantics.g2d.element.handler.LifeCycle;

/**
 * 
 * @See {@link Color}
 * @author Toni Kalajainen
 */
public class BorderColorImpl implements BorderColor, LifeCycle {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 9146714542866437248L;
	public static final BorderColorImpl UNSET = new BorderColorImpl(null);
	public static final BorderColorImpl BLACK = new BorderColorImpl(java.awt.Color.BLACK);
	public static final BorderColorImpl WHITE = new BorderColorImpl(java.awt.Color.WHITE);
	public static final BorderColorImpl RED = new BorderColorImpl(java.awt.Color.RED);
	public static final BorderColorImpl BLUE = new BorderColorImpl(java.awt.Color.BLUE);
		
	public synchronized static BorderColorImpl handlerOf(java.awt.Color c)
	{
		return new BorderColorImpl(c);
	}
	
	java.awt.Color defaultColor = java.awt.Color.BLACK;
	
	public BorderColorImpl() {}
	public BorderColorImpl(java.awt.Color defaultColor) {
		this.defaultColor = defaultColor;
	}
	
	@Override
	public java.awt.Color getBorderColor(IElement e) {		
		return e.getHint(ElementHints.KEY_BORDER_COLOR);
	}

	@Override
	public void setBorderColor(IElement e, java.awt.Color c) {
		e.setHint(ElementHints.KEY_BORDER_COLOR, c);
	}
	
	@Override
	public void onElementActivated(IDiagram d, IElement e) {
	}
	@Override
	public void onElementCreated(IElement e) {
		if (defaultColor!=null)
			e.setHint(ElementHints.KEY_BORDER_COLOR, defaultColor);
	}
	@Override
	public void onElementDeactivated(IDiagram d, IElement e) {
	}
	@Override
	public void onElementDestroyed(IElement e) {
	}
}
