/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.Color;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.AdditionalColor;
import org.simantics.g2d.element.handler.LifeCycle;

/**
 * 
 * @See {@link Color}
 * @author Toni Kalajainen
 */
public class AdditionalColorImpl implements AdditionalColor, LifeCycle {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5597731950979011697L;
	public static final AdditionalColorImpl BLACK = new AdditionalColorImpl(java.awt.Color.BLACK);
	public static final AdditionalColorImpl WHITE = new AdditionalColorImpl(java.awt.Color.WHITE);
	public static final AdditionalColorImpl RED = new AdditionalColorImpl(java.awt.Color.RED);
	public static final AdditionalColorImpl BLUE = new AdditionalColorImpl(java.awt.Color.BLUE);
	public static final AdditionalColorImpl GREEN = new AdditionalColorImpl(java.awt.Color.GREEN);
	public static final AdditionalColorImpl GRAY = new AdditionalColorImpl(java.awt.Color.GRAY);
		
	public synchronized static AdditionalColorImpl handlerOf(java.awt.Color c)
	{
		return new AdditionalColorImpl(c);
	}
	
	java.awt.Color defaultColor = java.awt.Color.BLACK;
	
	public AdditionalColorImpl() {}
	public AdditionalColorImpl(java.awt.Color defaultColor) {
		this.defaultColor = defaultColor;
	}
	
	@Override
	public java.awt.Color getAdditionalColor(IElement e) {		
		return e.getHint(ElementHints.KEY_ADDITIONAL_COLOR);
	}

	@Override
	public void setAdditionalColor(IElement e, java.awt.Color c) {
		e.setHint(ElementHints.KEY_ADDITIONAL_COLOR, c);
	}
	
	@Override
	public void onElementActivated(IDiagram d, IElement e) {
	}
	@Override
	public void onElementCreated(IElement e) {
		e.setHint(ElementHints.KEY_ADDITIONAL_COLOR, defaultColor);
	}
	@Override
	public void onElementDeactivated(IDiagram d, IElement e) {
	}
	@Override
	public void onElementDestroyed(IElement e) {
	}
}
