/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.TextSegment;

/**
 * A handler for supporting inline editing of elements.
 * 
 * @author Antti Villberg
 */
public interface TextEditor extends ElementHandler {

    public interface Modifier {
        /**
         * Returns the value for the property referred by this modifier. Must
         * not return <code>null</code> since the existence of this Modifier
         * should be enough proof that a modifiable value actually does exist.
         * 
         * @return the original property value to be modified
         */
        public String getValue(IElement element);

        /**
         * @param text the text to test for validity
         * @return <code>null</code> if the specified label is valid for this
         *         modifier or an error message if the label is invalid
         */
        public String isValid(IElement element, String text);

        /**
         * @param element the element to modify
         * @param text the new text value to set for the specified element
         * @throws IllegalArgumentException if the specified text is invalid
         */
        void modify(IElement element, String text) throws IllegalArgumentException;
    }

    boolean isActive(IElement e);
    void setActive(IElement e, boolean value);

    String getText(IElement e);
    void setText(IElement e, String text);

    Modifier getModifier(IElement e);
    void setModifier(IElement e, Modifier modifier);

    /**
     * @param e
     * @return <code>null</code> if there is no selection
     */
    TextSegment getSelection(IElement e);

    /**
     * @param e
     * @param segment a valid selection for the current text or
     *        <code>null</code> to remove selection
     */
    void setSelection(IElement e, TextSegment segment);

    /**
     * @param e
     * @return a value between [0, {@link #getText(IElement)}.length()] or
     *         <code>null</code> if no caret.
     */
    Integer getCaretPosition(IElement e);

    /**
     * @param e
     * @param position <code>null</code> to remove caret position
     */
    void setCaretPosition(IElement e, Integer position);

}
