/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.TextImpl;

/**
 * 
 * @See {@link TextImpl} for default implementation
 * @author Toni Kalajainen
 */
public interface Text extends ElementHandler {

	public static final Text INSTANCE = TextImpl.INSTANCE;
	
	/**
	 * @param e the element to retrieve text from
	 * @return <code>null</code> if there is no text
	 */
	String getText(IElement e);

    /**
     * @param e the element to set text for
     * @param text the text to set, use <code>null</code> to remove text
     */
	void setText(IElement e, String text);
	
}
