/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.util.Collection;

import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.StaticTerminals;

/**
 * 
 * @see TerminalLayout Terminal layout interface
 * @see StaticTerminals Implementation for elements with static terminals (most cases)
 * @see TerminalPainter A diagram participant that implements painting of element terminals
 * @see Topology
 * @author Toni Kalajainen
 */
public interface TerminalTopology extends ElementHandler {

    void getTerminals(IElement node, Collection<Terminal> result);

}
