/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.Shape;
import java.awt.geom.AffineTransform;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.StaticTerminals;
import org.simantics.g2d.utils.geom.DirectionSet;

/**
 * 
 * @See {@link TerminalTopology} Enumeration of terminals
 * @See {@link StaticTerminals} Compile handler for elements with static terminals (almost all)
 * @author Toni Kalajainen
 */
public interface TerminalLayout extends ElementHandler {
	
	/**
	 * Get specified terminal transformation on specified element
	 * 
	 * @param node
	 * @param t
	 * @return position of a terminal or null if specified terminal does not
	 *         belong to the specified element. The returned AffineTransform
	 *         must be treated as if it were immutable since the implementation
	 *         is allowed to returned singleton/cached values.
	 */
	AffineTransform getTerminalPosition(IElement node, Terminal t);
	
	/**
	 * Get Terminal direction  
	 * @param node node
	 * @param t terminal
	 * @param directions collection where directions are added (compass direction, 0 + n*360=north, n e N)
	 * @return true if this handler could tell the terminal direction 
	 */
	boolean getTerminalDirection(IElement node, Terminal t, DirectionSet directions);
	
	/**
	 * Get shape of a terminal.
	 * If terminal has a shape its selection is based on it and is zoom-level dependent.
	 * If a terminal has no shape it is a point and zoom-level independent.
	 * 
	 * Only the area that fits into the element will be picked. 
	 * 
	 * @return shape shape or null
	 */
	Shape getTerminalShape(IElement node, Terminal t);
	
}
