/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Single;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * An element handler for elements with terminals that allows setting/getting
 * terminal-specific data to/from elements.
 * 
 * @see TerminalTopology Terminal topology interface
 * @see TerminalLayout Terminal layout interface
 * @see Topology
 * 
 * @author Tuukka Lehtonen
 */
@Single
public interface TerminalData extends ElementHandler {

    <T> T getHint(IElement e, Terminal t, Key key);

    void setHint(IElement e, Terminal t, Key key, Object value);

}
