/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.Shape;
import java.util.Collection;

import org.simantics.g2d.diagram.handler.PickRequest.PickPolicy;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.GeometryUtils;


/**
 * Pick-interface allows detailed pick test for an element.
 * If pick is not implemented, its ({@link Outline}) is used for pick test.
 * If outline is not implemented, its bounds is used for pick.
 * 
 * @See {@link InternalSize}
 * @See {@link BoundsPickable}
 * @See {@link GeometryUtils}
 * 
 * @author Tuukka Lehtonen
 */
public interface Pick2 extends Pick {

    /**
     * Try to pick the specified element and its possible children.
     * 
     * The pick results are put in the specified element collection.
     * 
     * @param e the element to pick test
     * @param s the picking shape to test against e
     * @param policy the criterion for picking acceptance
     * @param result the result collection into which the picked elements will
     *        be appended
     * @return the amount of elements intersecting/containing s. Tells the
     *         amount of elements added to the result collection.
     */
    int pick(IElement e, Shape s, PickPolicy policy, Collection<IElement> result);

}
