/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.geom.Point2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.MoveImpl;

/**
 * Class with Move handler is moveable. 
 * 
 * @See {@link DefaultTransform} default impl
 * @See {@link MoveImpl} default impl
 * @author Toni Kalajainen
 */
public interface Move extends ElementHandler {

	void moveTo(IElement e, double x, double y);
	Point2D getPosition(IElement e);
	
}
