/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.participant.ElementHeartbeater;
import org.simantics.g2d.element.IElement;

/**
 * A heartbeat has elapsed on a canvas.
 * 
 * 
 * @See {@link ElementHeartbeater} Required participant for this handler to work
 * @author Toni Kalajainen
 */
public interface Heartbeat extends ElementHandler {

	void heartbeat(IElement e, long time, long deltaTime, ICanvasContext ctx);
	
}
