/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.EnumSet;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.ConfigurableEdgeVisuals;
import org.simantics.g2d.element.handler.impl.StaticEdgeVisuals;

/**
 * Edge visual properties
 * 
 * @See {@link ConfigurableEdgeVisuals}
 * @See {@link StaticEdgeVisuals}
 * @author Toni Kalajainen
 * 
 * TODO: configurable arrow shape
 */
public interface EdgeVisuals extends ElementHandler {

    public static enum StrokeType { Absolute, Relative }

    public static enum ArrowType { None, Stroke, Fill, Both }

    public static interface Arrow {
        ArrowType getType();
        Color getStrokeColor();
        Color getFillColor();
        /**
         * @return the renderable arrow shape described by this arrow type. The
         *         returned shape is interpreted to be facing in the positive X
         *         direction (right), with 0 degree rotation
         */
        Shape getShape();
    }

    public static enum EdgeEnd {
        Begin, End;
        public EdgeEnd other() {
            return this == Begin ? End : Begin;
        }
    }

    public static EnumSet<EdgeEnd> BEGIN = EnumSet.of(EdgeEnd.Begin);
    public static EnumSet<EdgeEnd> END   = EnumSet.of(EdgeEnd.End);
    public static EnumSet<EdgeEnd> BOTH  = EnumSet.allOf(EdgeEnd.class);

    Stroke getStroke(IElement e);
    void setStroke(IElement e, Stroke s);

    StrokeType getStrokeType(IElement e);
    void setStrokeType(IElement e, StrokeType t);

    ArrowType getArrowType(IElement e, EdgeEnd end);
    void setArrowType(IElement e, EdgeEnd end, ArrowType arrowType);

    double getArrowSize(IElement e, EdgeEnd end);
    void setArrowSize(IElement e, EdgeEnd end, double size);

    // TODO: weight, transparency, corner rounds/rounding size

}
