/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.g2d.dnd;

import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;

import org.simantics.g2d.canvas.ICanvasParticipant;

/**
 * IDropParticipant is an interface for taking part of a DnD event. 
 * {@link IDnDContext} is a context used during the life cycle of the event.
 * 
 * IDnDParticipant implementations require {@link DropInteractor}. 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public interface IDropTargetParticipant extends ICanvasParticipant {

	void dragEnter(DropTargetDragEvent dtde, IDnDContext dp);
	
	void dragExit(DropTargetEvent dte, IDnDContext dp);

	void dragOver(DropTargetDragEvent dtde, IDnDContext dp);

	void drop(DropTargetDropEvent dtde, IDnDContext dp);
	
	void dropActionChanged(DropTargetDragEvent dtde, IDnDContext dp);
	
	/**
	 * Get allowed ops (See DnDConstants)
	 * @return
	 */
	int getAllowedOps();
	
	double getPriority();
	
}
