/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.dnd;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceListener;

import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseDragBegin;

/**
 * This is an interface allows objects to be dragged from the canvas.
 * Implementations produce serializable Transferable object in drag out event.
 * 
 * This participant requires {@link DragInteractor} installed in the canvas context.   
 * 
 * @author Toni Kalajainen
 */
public interface IDragSourceParticipant extends ICanvasParticipant, DragSourceListener {

    /** 
     * Can participant provide draggable content
     * @return 0 for no, others operations, see {@link DnDConstants}
     */
    int canDrag(MouseDragBegin me);

    Transferable dragStart(DragGestureEvent e);

    /**
     * Get allowed ops (See DnDConstants)
     * @return
     */
    int getAllowedOps();

}
