/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.g2d.dnd;

import java.awt.geom.Point2D;

import org.simantics.utils.datastructures.context.IContext;
import org.simantics.utils.datastructures.hints.IHintContext;

/**
 * A context that follows throughout a DnD process.
 * 
 * {@link DragPainter} paints any items added to the context.
 * Implementations of {@link IDropTargetParticipant} take part in building IDnDContext.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public interface IDnDContext extends IContext<IDragItem> {

    IHintContext getHints();

    Point2D getItemPosition(IDragItem item);
    void setItemPosition(IDragItem item, Point2D pos);

}
