/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.participant;

import java.awt.datatransfer.Transferable;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.nodes.TransferableProvider;
import org.simantics.ui.dnd.PlaintextTransfer;

/**
 * @author Antti Villberg, Tuukka Lehtonen
 */
public class ElementTransferableProvider implements TransferableProvider {

	final private ICanvasContext context;
	final private IElement element;
	
	public ElementTransferableProvider(ICanvasContext context, IElement element) {
		this.context = context;
		this.element = element;
	}
	
	@Override
	public Transferable create() {
		ElementJSON converter = context.getAtMostOneItemOfClass(ElementJSON.class);
		if (converter == null)
			return null;
		return converter.getJSON(element).map(PlaintextTransfer::new).orElse(null);
	}

}
