/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.participant;

import java.util.Optional;

import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.element.IElement;

/**
 * @author Antti Villberg
 */
public interface ElementJSON extends ICanvasParticipant {
	
	/**
	 * @param element
	 * @return JSON that describes the provided diagram element
	 */
	public Optional<String> getJSON(IElement element);

}
