/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.participant;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Heartbeat;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.scenegraph.g2d.events.TimeEvent;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection.EventHandler;

/**
 * This participant sends time events to Heartbeat element handlers.
 * 
 * @See {@link Heartbeat}
 * @author Toni Kalajainen
 */
public class ElementHeartbeater extends AbstractDiagramParticipant {

    @Dependency TimeParticipant time;

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        time.registerForEvents(getClass());
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
   	 	time.unregisterForEvents(getClass());
        super.removedFromContext(ctx);
    }

    @EventHandler(priority = 0)
    public boolean handleHeartbeat(TimeEvent te) {
        IDiagram d = diagram;
        if (d==null) return false;
        for (IElement e : d.getSnapshot())
        {
            for (Heartbeat hb : e.getElementClass().getItemsByClass(Heartbeat.class))
                hb.heartbeat(e, te.time, te.interval, getContext());
        }
        return false;
    }

}
