/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.LifeCycle;
import org.simantics.g2d.diagram.handler.TransactionContext;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.ListenerList;

/**
 * @author Toni Kalajainen
 */
public class TransactionContextImpl implements TransactionContext, LifeCycle {

    Map<IDiagram, ListenerList<TransactionListener>> list =
        new HashMap<IDiagram, ListenerList<TransactionListener>>();

    @Override
    public void addTransactionListener(IDiagram d, TransactionListener l) {
        ListenerList<TransactionListener> ll = list.get(d);
        if (ll==null) {
            ll = new ListenerList<TransactionListener>(TransactionListener.class);
            list.put(d, ll);
        }
        ll.add(l);
    }

    @Override
    public void removeTransactionListener(IDiagram d, TransactionListener l) {
        ListenerList<TransactionListener> ll = list.get(d);
        if (ll==null) return;
        ll.remove(l);
    }

    @Override
    public void onDiagramDestroyed(IDiagram diagram) {
    }

    @Override
    public void onDiagramDisposed(IDiagram diagram) {
        list.remove(diagram);
    }

    @Override
    public void onDiagramCreated(IDiagram diagram) {
    }

//	@Override
//	public void finishTransaction(IDiagram d, Transaction t, ChangeSet cs) {
//		ListenerList<TransactionListener> ll = list.get(d);
//		if (ll==null) return;
//		for (TransactionListener l : ll.getListeners())
//			l.transactionFinished(d, t, cs);
//	}

//	@Override
//	public void startTransaction(IDiagram d, Transaction t) {
//		ListenerList<TransactionListener> ll = list.get(d);
//		if (ll==null) return;
//		for (TransactionListener l : ll.getListeners())
//			l.transactionStarted(d, t);
//	}

    @Override
    public void onDiagramLoaded(IDiagram diagram, Collection<IElement> initialElements) {
    }

    @Override
    public Transaction startTransaction(IDiagram d, TransactionType type) {
        Transaction t = new Transaction.Impl(type);
        ListenerList<TransactionListener> ll = list.get(d);
        if (ll != null)
            for (TransactionListener l : ll.getListeners())
                l.transactionStarted(d, t);
        return t;
    }

    @Override
    public void finishTransaction(IDiagram d, Transaction t) {
        ListenerList<TransactionListener> ll = list.get(d);
        if (ll == null)
            return;
        for (TransactionListener l : ll.getListeners())
            l.transactionFinished(d, t);
    }

//    @Override
//    public void cancelTransaction(IDiagram d, Transaction t) {
//        ListenerList<TransactionListener> ll = list.get(d);
//        if (ll == null)
//            return;
//        for (TransactionListener l : ll.getListeners())
//            l.transactionCanceled(d, t);
//    }

}
