/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass.Required;
import org.simantics.g2d.element.ElementClass.Single;

/**
 * @author Toni Kalajainen
 */
@Single
@Required
public interface TransactionContext extends DiagramHandler {

    public static enum TransactionType {
        READ, WRITE
    }

    public static interface Transaction {
        TransactionType getType();

        public static class Impl implements Transaction {
            TransactionType type;
            public Impl(TransactionType type) {
                this.type = type;
            }
            @Override
            public TransactionType getType() {
                return type;
            }
            @Override
            public String toString() {
                return "Transaction.Impl[" + type + "]";
            }
        }
    }

    /**
     * A listener for diagram transaction context events.
     */
    public static interface TransactionListener {
        /**
         * Invoked when the transaction has been started and locked properly
         * using
         * {@link TransactionContext#startTransaction(IDiagram, TransactionType)}
         * .
         * 
         * @param d the diagram where the transaction has started
         * @param t the transaction handle
         */
        void transactionStarted(IDiagram d, Transaction t);

        /**
         * Invoked if a transaction is committed using
         * {@link TransactionContext#finishTransaction(IDiagram, Transaction)}
         * while transaction t still holds on to its lock, either read or write.
         * 
         * @param d the diagram where the transaction took place
         * @param t the transaction handle
         */
        void transactionFinished(IDiagram d, Transaction t);
    }

    void addTransactionListener(IDiagram d, TransactionListener l);
    void removeTransactionListener(IDiagram d, TransactionListener l);

    Transaction startTransaction(IDiagram d, TransactionType type);
    void finishTransaction(IDiagram d, Transaction t);

//    /**
//     * @deprecated will be removed
//     */
//    @Deprecated
//    public static class ChangeSet {
//        public List<IElement>             added, removed;
//        public Map<IElement, HintContext> modifications;
//    }

}
