/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler;

import java.util.Collection;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;

/**
 * @author Toni Kalajainen
 */
public interface LifeCycle extends DiagramHandler {

    /**
     * New empty diagram has spawned to the world.
     * 
     * @param diagram
     */
    void onDiagramCreated(IDiagram diagram);

    /**
     * An old diagram has been restored from a other form of state
     * (loaded or cloned).
     * 
     * @param diagram
     */
    void onDiagramLoaded(IDiagram diagram, Collection<IElement> initialElements);

    /**
     * Diagram is about to be disposed
     * @param diagram
     */
    void onDiagramDisposed(IDiagram diagram);

    /**
     * Diagram is about to be destoyed permanently from the world
     * @param diagram
     */
    void onDiagramDestroyed(IDiagram diagram);

    /**
     * A stub implementation for {@link LifeCycle} that does not do anything.
     * Extend this to avoid having to implement all methods.
     */
    public class Stub implements LifeCycle {
        @Override
        public void onDiagramCreated(IDiagram diagram) {
        }

        @Override
        public void onDiagramLoaded(IDiagram diagram, Collection<IElement> initialElements) {
        }

        @Override
        public void onDiagramDisposed(IDiagram diagram) {
        }

        @Override
        public void onDiagramDestroyed(IDiagram diagram) {
        }
    }
}
