/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.layout.BorderLayout;
import org.simantics.g2d.diagram.handler.layout.FlowLayout;
import org.simantics.g2d.diagram.handler.layout.GridLayout;

/**
 * LayoutManager puts elements on diagram. 
 * layout() method must be explicitely invoked.
 * 
 * Diagram must have size hint (DiagramHints.KEY_BOUNDS).
 * 
 * @See {@link FlowLayout}
 * @See {@link GridLayout}
 * @See {@link BorderLayout}
 * @author Toni Kalajainen
 */
public interface LayoutManager extends DiagramHandler {

	/**
	 * Lay-out elements on the diagram. 
	 * 
	 * @param diagram
	 */
    void layout(IDiagram diagram, Rectangle2D bounds);
	
    /**
     * Computes and returns the size of the specified
     * composite's client area according to this layout.
     * <p>
     * This method computes the size that the client area 
     * of the composite must be in order to position all 
     * children at their preferred size inside the
     * composite according to the layout algorithm
     * encoded by this layout.
     * </p>
     * <p>
     * When a width or height hint is supplied, it is
     * used to constrain the result. For example, if a
     * width hint is provided that is less than the
     * width of the client area, the layout may choose
     * to wrap and increase height, clip, overlap, or
     * otherwise constrain the children.
     * </p>
     *
     * @param composite a composite widget using this layout
     * @param wHint width (<code>null</code> for preferred size)
     * @param hHint height (<code>null</code> for preferred size)
     * @return the computed size (width, height)
     */
	Rectangle2D computeSize(IDiagram diagram, Double wHint, Double hHint);     
	
}
