/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;

/**
 * @author Toni Kalajainen
 */
public interface ElementListener extends DiagramHandler {

	/**
	 * New element added to the diagram. This does not include elements
	 * that were loaded during initialization.
	 * 
	 * @param d
	 * @param e
	 */
	void onElementAdded(IDiagram d, IElement e);
	
	/**
	 * Element removed from the diagram. This excludes uninitializations.
	 * 
	 * @param d
	 * @param e
	 */
	void onElementRemoved(IDiagram d, IElement e);
	
}
