/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.g2d.diagram.handler.DiagramHandler;
import org.simantics.g2d.diagram.handler.impl.DataElementMapImpl;
import org.simantics.g2d.diagram.handler.impl.LockingTransactionContext;
import org.simantics.g2d.diagram.handler.impl.PickContextImpl;
import org.simantics.g2d.diagram.handler.impl.TopologyImpl;
import org.simantics.g2d.diagram.impl.AbstractHandlerClass;

/**
 * DiagramClass is a compilation of DiagramHandlers
 * 
 * @See {@link DiagramHandler}
 * @author Toni Kalajainen
 */
public final class DiagramClass extends AbstractHandlerClass<DiagramHandler> {

    private static final long serialVersionUID = 1541784948072436274L;

    /**
     * Compile new Diagram class from a set of contributions
     * @param contributions
     * @return
     */
    public static DiagramClass compile(Collection<DiagramHandler> contributions)
    {
        return new DiagramClass(contributions);
    }

    /**
     * Compile new Diagram class from a set of contributions
     * @param contributions
     * @return
     */
    public static DiagramClass compile(DiagramHandler... contributions)
    {
        ArrayList<DiagramHandler> al = new ArrayList<DiagramHandler>(contributions.length);
        for (DiagramHandler eh : contributions)
            al.add(eh);
        return new DiagramClass(al);
    }

    DiagramClass(Collection<DiagramHandler> contributions) {
        super(contributions);
    }

    public static final DiagramClass DEFAULT =
        DiagramClass.compile(
                new PickContextImpl(),
                new LockingTransactionContext(),
                new TopologyImpl(),
                //ConnectionValidator.INSTANCE,
                new DataElementMapImpl()
        );

    public DiagramClass newClassWith(DiagramHandler... addedHandlers) {
        Collection<DiagramHandler> newHandlers = new ArrayList<DiagramHandler>(getAll());
        for (DiagramHandler h : addedHandlers)
            newHandlers.add(h);
        return DiagramClass.compile(newHandlers);
    }

    public DiagramClass newClassWith(Collection<DiagramHandler> addedHandlers) {
        Collection<DiagramHandler> newHandlers = new ArrayList<DiagramHandler>(getAll());
        newHandlers.addAll(addedHandlers);
        return DiagramClass.compile(newHandlers);
    }

}
