/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.connection.handler;

import java.util.Collection;

import org.simantics.g2d.diagram.handler.Topology.Connection;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Single;
import org.simantics.g2d.element.handler.ElementHandler;

/**
 * @author Tuukka Lehtonen
 */
@Single
public interface ConnectionHandler extends ElementHandler {

    /**
     * Get all sub-elements (branch points, edge segments) of the specified
     * connection element. If the element is not a connection, an empty result
     * shall be returned.
     * 
     * @param connection
     * @param result
     * @return
     */
    Collection<IElement> getChildren(IElement connection, Collection<IElement> result);

    /**
     * Get all branch points that are part of this connection. If the element is
     * not a connection, an empty result shall be returned.
     * 
     * @param result the collection to store the result into or
     *        <code>null</code> to allocate a new collection
     * @return the result collection
     */
    Collection<IElement> getBranchPoints(IElement connection, Collection<IElement> result);

    /**
     * Get all segments that are part of this connection. If the element is not
     * a connection, an empty result shall be returned.
     * 
     * @param result the collection to store the result into or
     *        <code>null</code> to allocate a new collection
     * @return the result collection
     */
    Collection<IElement> getSegments(IElement connection, Collection<IElement> result);

    /**
     * Get all topological terminal connections of this connection entity.
     * Terminal connections are the only way to attach a connection to an
     * element terminal. If the element is not a connection, an empty result
     * shall be returned.
     * 
     * @param result the collection to store the result into or
     *        <code>null</code> to allocate a new collection
     * @return the result collection
     */
    Collection<Connection> getTerminalConnections(IElement connection, Collection<Connection> result);

}
