/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.connection;

import org.simantics.g2d.diagram.handler.Topology.Connection;
import org.simantics.g2d.element.handler.EdgeVisuals.EdgeEnd;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * @author Tuukka Lehtonen
 */
public class EndKeyOf extends KeyOf {

    private final EdgeEnd end;
    private int hash;

    private static final EndKeyOf  BEGIN = new EndKeyOf(EdgeEnd.Begin, Connection.class);
    private static final EndKeyOf  END   = new EndKeyOf(EdgeEnd.End, Connection.class);
    public static final EndKeyOf[] KEYS  = { BEGIN, END };

    public static EndKeyOf get(EdgeEnd end) {
        switch (end) {
            case Begin: return BEGIN;
            case End: return END;
            default: throw new IllegalArgumentException("unrecognized EdgeEnd value: " + end);
        }
    }

    private EndKeyOf(EdgeEnd end, Class<?> clazz) {
        super(clazz);
        this.end = end;
        hash = end.hashCode();
    }

    public EdgeEnd getEnd() {
        return end;
    }

    @Override
    public int hashCode() {
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EndKeyOf))
            return false;
        EndKeyOf other = (EndKeyOf) obj;
        if (!other.end.equals(end)) return false;
        return true;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + end + "]";
    }

}