/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.chassis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Tooltip extends JFrame {

	JPanel panel;
	
	Tooltip() {
		super();
		panel = new JPanel();
		panel.setBorder(BorderFactory.createLineBorder(Color.black));
		add(panel);
		
		addMouseListener( ml );
		// Mouse Capture
//		long eventMask = AWTEvent.MOUSE_MOTION_EVENT_MASK + AWTEvent.MOUSE_EVENT_MASK;
//		Toolkit.getDefaultToolkit().addAWTEventListener( new AWTEventListener()
//		{
//		    public void eventDispatched(AWTEvent e)
//		    {
//		        System.out.println(e);
//		    }
//		}, eventMask);
		
		setFocusableWindowState(false);
		setUndecorated(true);
	
		setAlwaysOnTop(true);
		Color c = new Color(255, 255, 220);
		panel.setBackground( c );
		setFocusable(false);
		Point mouse = MouseInfo.getPointerInfo().getLocation();
		setLocation( mouse );
		setResizable(false);
		
		pack();
		setVisible( true );	
	}
	
	public Tooltip( String...tips )
	{
		this();
		GridLayout gl = new GridLayout(tips.length, 1, 5, 5);
//		Insets i = new Insets(3, 3, 3, 3);
		panel.setLayout( gl );
		for (String tip : tips) {
			JLabel label = new JLabel( tip );
			panel.add( label );
		}
		pack();
		setVisible( true );
	}
	
	public Tooltip( Component component )
	{
		this();
		setContent( component );
	}
	
	void setContent( Component component ) {
		panel.add( component, BorderLayout.CENTER );
		pack();
		setVisible( true );
	}
	
	MouseListener ml = new MouseAdapter() {
		public void mouseExited(java.awt.event.MouseEvent e) {
		    if (e.getSource() == Tooltip.this) {
				Tooltip.this.dispose();
		    }
		};
		
		public void mouseClicked(java.awt.event.MouseEvent e) {
			Tooltip.this.dispose();
		};
	};

}
